#ifndef __MathTools__
#define __MathTools__

/**
 * @file MathTools.h
 * @brief Single include for the math package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: MathTools.h,v 1.8 2007/02/08 21:06:44 paul Exp $
 */

/**
 * @namespace Exponent::MathTools
 * @brief Math functionality namespace
 *
 * Maths related objects can be found here!
 */

#include "CBounds.hpp"
#include "CDimension.hpp"
#include "CExponentParameter.hpp"
#include "CMathTools.hpp"
#include "CParameter.hpp"
#include "CPoint.hpp"
#include "CPolygon.hpp"
#include "CRect.hpp"
#include "TComplex.hpp"
#include "TRandomNumberGenerator.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::MathTools;
#endif

#endif	// End of math